/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.gui;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.gui.NavigatableSimiScreen;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ScreenOpener {
    private static final Deque<class_437> backStack = new ArrayDeque<class_437>();
    @Nullable
    private static class_437 backSteppedFrom = null;

    public static void open(@Nullable class_437 screen) {
        ScreenOpener.open(class_310.method_1551().field_1755, screen);
    }

    public static void open(@Nullable class_437 current, @Nullable class_437 toOpen) {
        backSteppedFrom = null;
        if (current != null) {
            if (backStack.size() >= 15) {
                backStack.pollLast();
            }
            backStack.push(current);
        } else {
            backStack.clear();
        }
        ScreenOpener.openScreen(toOpen);
    }

    public static void openPreviousScreen(class_437 current, @Nullable NavigatableSimiScreen screenWithContext) {
        if (backStack.isEmpty()) {
            return;
        }
        backSteppedFrom = current;
        class_437 previousScreen = backStack.pop();
        if (previousScreen instanceof NavigatableSimiScreen) {
            NavigatableSimiScreen previousNavScreen = (NavigatableSimiScreen)previousScreen;
            if (screenWithContext != null) {
                screenWithContext.shareContextWith(previousNavScreen);
            }
            previousNavScreen.transition.startWithValue(-0.001).chase(-1.0, 0.3f, LerpedFloat.Chaser.EXP);
        }
        ScreenOpener.openScreen(previousScreen);
    }

    public static void transitionTo(NavigatableSimiScreen screen) {
        if (ScreenOpener.tryBackTracking(screen)) {
            return;
        }
        screen.transition.startWithValue(0.001).chase(1.0, 0.3f, LerpedFloat.Chaser.EXP);
        ScreenOpener.open(screen);
    }

    private static boolean tryBackTracking(NavigatableSimiScreen screen) {
        List<class_437> screenHistory = ScreenOpener.getScreenHistory();
        if (screenHistory.isEmpty()) {
            return false;
        }
        class_437 previouslyRenderedScreen = screenHistory.get(0);
        if (!(previouslyRenderedScreen instanceof NavigatableSimiScreen)) {
            return false;
        }
        if (!screen.isEquivalentTo((NavigatableSimiScreen)previouslyRenderedScreen)) {
            return false;
        }
        ScreenOpener.openPreviousScreen(class_310.method_1551().field_1755, screen);
        return true;
    }

    public static void clearStack() {
        backStack.clear();
    }

    public static List<class_437> getScreenHistory() {
        return new ArrayList<class_437>(backStack);
    }

    @Nullable
    public static class_437 getBackStepScreen() {
        return backStack.peek();
    }

    @Nullable
    public static class_437 getPreviouslyRenderedScreen() {
        return backSteppedFrom != null ? backSteppedFrom : backStack.peek();
    }

    private static void openScreen(@Nullable class_437 screen) {
        class_310.method_1551().method_18858(() -> {
            class_310.method_1551().method_1507(screen);
            class_437 previouslyRenderedScreen = ScreenOpener.getPreviouslyRenderedScreen();
            if (previouslyRenderedScreen != null && screen instanceof NavigatableSimiScreen) {
                previouslyRenderedScreen.method_25423(class_310.method_1551(), screen.field_22789, screen.field_22790);
            }
        });
    }
}

